/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.sql.ConnectionWrapper;
import org.codefilarete.tool.sql.TransactionSupport;
import org.codefilarete.tool.trace.MutableBoolean;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TransactionSupportTest {
    TransactionSupportTest() {
    }

    @Test
    void commitStateReversion_true() throws SQLException {
        final MutableBoolean commitState = new MutableBoolean(Boolean.valueOf(true));
        TransactionSupport testInstance = new TransactionSupport((Connection)new ConnectionWrapper(){

            public boolean getAutoCommit() {
                return commitState.getValue();
            }

            public void setAutoCommit(boolean autoCommit) {
                commitState.setValue(Boolean.valueOf(autoCommit));
            }
        });
        testInstance.begin();
        Assertions.assertThat((Boolean)commitState.getValue()).isFalse();
        testInstance.end();
        Assertions.assertThat((Boolean)commitState.getValue()).isTrue();
    }

    @Test
    void commitStateReversion_false() throws SQLException {
        final MutableBoolean commitState = new MutableBoolean(Boolean.valueOf(false));
        TransactionSupport testInstance = new TransactionSupport((Connection)new ConnectionWrapper(){

            public boolean getAutoCommit() {
                return commitState.getValue();
            }

            public void setAutoCommit(boolean autoCommit) {
                commitState.setValue(Boolean.valueOf(autoCommit));
            }
        });
        testInstance.begin();
        Assertions.assertThat((Boolean)commitState.getValue()).isFalse();
        testInstance.end();
        Assertions.assertThat((Boolean)commitState.getValue()).isFalse();
    }

    @Test
    void end_connectionAutoCommitIsCalledIfNecessary() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TransactionSupport testInstance = new TransactionSupport(connectionMock);
        testInstance.begin();
        ((Connection)Mockito.verify((Object)connectionMock, (VerificationMode)Mockito.times((int)0))).setAutoCommit(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)connectionMock.getAutoCommit()).thenReturn((Object)true);
        testInstance.begin();
        ((Connection)Mockito.verify((Object)connectionMock)).setAutoCommit(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    void runAtomically_consumer_normalCase() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TransactionSupport testInstance = new TransactionSupport(connectionMock);
        TransactionSupport spy = (TransactionSupport)Mockito.spy((Object)testInstance);
        Object[] consumerState = new Object[1];
        spy.runAtomically(c -> {
            consumerState[0] = c;
        });
        ((TransactionSupport)Mockito.verify((Object)spy)).commit();
        ((Connection)Mockito.verify((Object)connectionMock)).commit();
        ((TransactionSupport)Mockito.verify((Object)spy)).begin();
        Assertions.assertThat((Object)consumerState[0]).isSameAs((Object)connectionMock);
        ((TransactionSupport)Mockito.verify((Object)spy)).end();
    }

    @Test
    void runAtomically_consumer_rollbackOnException() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TransactionSupport testInstance = new TransactionSupport(connectionMock);
        TransactionSupport spy = (TransactionSupport)Mockito.spy((Object)testInstance);
        Assertions.assertThatThrownBy(() -> spy.runAtomically(c -> {
            throw new SQLException();
        })).isNotNull();
        ((TransactionSupport)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)connectionMock, (VerificationMode)Mockito.never())).commit();
        ((TransactionSupport)Mockito.verify((Object)spy)).begin();
        ((TransactionSupport)Mockito.verify((Object)spy)).rollback();
        ((TransactionSupport)Mockito.verify((Object)spy)).end();
    }

    @Test
    void runAtomically_function_normalCase() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TransactionSupport testInstance = new TransactionSupport(connectionMock);
        TransactionSupport spy = (TransactionSupport)Mockito.spy((Object)testInstance);
        Connection consumerState = (Connection)spy.runAtomically(c -> c);
        ((TransactionSupport)Mockito.verify((Object)spy)).commit();
        ((Connection)Mockito.verify((Object)connectionMock)).commit();
        ((TransactionSupport)Mockito.verify((Object)spy)).begin();
        Assertions.assertThat((Object)consumerState).isSameAs((Object)connectionMock);
        ((TransactionSupport)Mockito.verify((Object)spy)).end();
    }

    @Test
    void runAtomically_function_rollbackOnException() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        TransactionSupport testInstance = new TransactionSupport(connectionMock);
        TransactionSupport spy = (TransactionSupport)Mockito.spy((Object)testInstance);
        Assertions.assertThatThrownBy(() -> spy.runAtomically(c -> {
            throw new SQLException();
        })).isNotNull();
        ((TransactionSupport)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)connectionMock, (VerificationMode)Mockito.never())).commit();
        ((TransactionSupport)Mockito.verify((Object)spy)).begin();
        ((TransactionSupport)Mockito.verify((Object)spy)).rollback();
        ((TransactionSupport)Mockito.verify((Object)spy)).end();
    }
}

